///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _TABGENERAL_CPP
#define _TABGENERAL_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabGeneralDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hProductText;
    static HWND hVersionText;
    static HWND hBuildDateText;
    static HWND hOSText;
    static HWND hMemoryText;
    static HWND hProcesorsText;

    if(uMsg == WM_INITDIALOG)
    {
        hProductText     = GetDlgItem(hWnd, IDC_PRODUCTTEXT);
        hVersionText     = GetDlgItem(hWnd, IDC_VERSIONTEXT);
        hBuildDateText   = GetDlgItem(hWnd, IDC_BUILDDATETEXT);
        hOSText          = GetDlgItem(hWnd, IDC_OSTEXT);
        hMemoryText      = GetDlgItem(hWnd, IDC_MEMORYTEXT);
        hProcesorsText   = GetDlgItem(hWnd, IDC_PROCESORSTEXT);

        //------------------------------------(Fill in general information begin)
        SYSTEM_INFO SI;
        GetSystemInfo(&SI);

        MEMORYSTATUS MS;
        MS.dwLength = sizeof(&MS);
        GlobalMemoryStatus(&MS);

        char sTempText[1024];

        Set_Text(hProductText, gsTitleCaption);

        sprintf_s(sTempText, sizeof(sTempText), "%s at %s", __DATE__, __TIME__);
        Set_Text(hBuildDateText, sTempText);

        Set_Text(hVersionText, gsFileVersion);

        Get_OsVersionEx(sTempText);
        Set_Text(hOSText, sTempText);

        sprintf_s(sTempText, sizeof(sTempText), "%d MB", MS.dwTotalPhys/1024/1024);
        Set_Text(hMemoryText, sTempText);

        sprintf_s(sTempText, sizeof(sTempText), "%d", SI.dwNumberOfProcessors);
        Set_Text(hProcesorsText, sTempText);
        // ------------------------------------(Fill in general information end)

        return TRUE;
    }

    if(uMsg == WM_COMMAND)
    {

        return FALSE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
